
// Toroidal coil
// only a cross section is represented
// cylindrical symmetry around (OY) is assumed

Include "torus.par" ;

Group {
	B_ext = Region[64] ; 
	OY = Region[65] ;
	CoilSection = Region[63] ;
	Coil = Region[79] ;

	D = Region[66] ;
	D_inf = Region[67] ;
	D_tot = Region[{D,D_inf}] ;
}

N = 1000 ;	// nb of windings 
I = 1 ; 	// Current in the wire (A)

Function {
	mu0 = 4*Pi*1e-7 ;

	// Surface current defined on CoilSection (a closed curve) :
	
	j_s[CoilSection] = N*I / (2*Pi*X[]) ;	// surface current on the coil
					// X[] = radial distance
	J_s[CoilSection] = j_s[] * Tangent[] ;  // vector

	// Surface current defined on Coil (a surface) :

	j_s[Coil] = N*I / (2*Pi*Norm[Vector[$1,0,$3]]) ;
	J_s[Coil] = j_s[$1,0,$3] * Unit[Cross[Normal[],Vector[-$3,0,$1]]] ;
	// Parameter : [$1,$2,$3] = [X,Y,Z]

}


Jacobian {

// Used in the FEM Galerkin formulation : 

  { Name JVol ;
    Case { 
        { Region D_inf ; Jacobian VolAxiSphShell {R_int, R_ext} ; }
        { Region All ; Jacobian VolAxi ; }
    }
  }
  { Name JSurAxi ;
    Case { 
      { Region CoilSection ; Jacobian SurAxi ; }
    }
  }

// Used in the Integral expression :

  { Name JSur ;
    Case {
      { Region All ; Jacobian Sur ; }
    }
  }

}


Integration {
  { Name I ;
    Case { 
      { Type Gauss ;
        Case { 
          { GeoElement Line        ; NumberOfPoints  3 ; }
          { GeoElement Triangle    ; NumberOfPoints  4 ; }
          { GeoElement Quadrangle  ; NumberOfPoints  4 ; }
        }
      }
    }
  }
}

Constraint {
	{ Name gauge_condition ;
	  Case {
	    { Region D_tot ; Type Assign ; Value 0 ; }
	  }
        }
}


FunctionSpace {

// Used for the FEM Galerkin formulation :

        { Name potentiel_vecteur_jauge ; Type Form1 ;
          BasisFunction {
             { Name w_n ; NameOfCoef a_n ; Function BF_Edge ;
               Support Region[{D_tot,CoilSection}] ; Entity EdgesOf[ All ] ; }
          }
          Constraint {
		{ NameOfCoef a_n ; EntityType EdgesOfTreeIn ;
                  NameOfConstraint gauge_condition ; } 
          }
        }

// Used for the integral expression :

        { Name potentiel_vecteur ; Type Form1 ;
          BasisFunction {
             { Name w_n ; NameOfCoef a_n ; Function BF_Edge ;
               Support D_tot ; Entity EdgesOf[ All ] ; }
          }
        }

        { Name champ_mag ; Type Form2 ;
          BasisFunction {
             { Name w_n ; NameOfCoef b_n ; Function BF_Facet ;
               Support D_tot ; Entity FacetsOf[ All ] ; }
          }
        }

}


Formulation {
  { Name formulation_du_probleme ; Type FemEquation ;
    Quantity {
      { Name a1 ; Type Local  ; NameOfSpace potentiel_vecteur_jauge ; }

      { Name B2 ; Type Integral ; NameOfSpace champ_mag ;
	[ mu0 *  Cross[ GradLaplace[]{3D} , J_s[$XS,$YS,$ZS] ]         ] ;
	In Coil ; Jacobian JSur ; Integration I ; }

/**************************/
// Tests :
      { Name a2 ; Type Integral ; NameOfSpace potentiel_vecteur ;

// essayer de changer le NameOfSpace (potentiel_vecteur / champ_mag) pour 
// voir ce que ça change -> ne change rien... ???

//	[ Vector[0,0,1] ] ;    	// works as expected : gives the surface of Coil

	[ J_s[$XS,$YS,$ZS] ] ;	// does not work : result should be \vec 0
		// and why is the vector reversed int the region D_inf, Y<0 ???

//	[ mu0 *  Laplace[]{3D} * J_s[$XS,$YS,$ZS] ];  
		// wrong direction  
	
        In Coil ; Jacobian JSur ; Integration I ; }   
/**************************/

    }

    Equation {

      Galerkin { [ 1/mu0 * Dof{Curl a1} , {Curl a1} ] ;
             In D_tot ; Jacobian JVol ; Integration I ; }
      
      Galerkin { [ - J_s[] , {a1} ] ;
             In CoilSection ; Jacobian JSurAxi ; Integration I ; }
    }
  }
}


Resolution {
  { Name resolution_du_probleme ;
    System {
      { Name A ; NameOfFormulation formulation_du_probleme ; }
    }
    Operation { 
      InitSolution[A];
      Generate[A] ; 
      Solve[A] ; 
      SaveSolution[A] ; 
    }
  }
}

PostProcessing {
  { Name post_processing ; NameOfFormulation formulation_du_probleme ;
    Quantity {
//   { Name a1 ; Value { Local { [ {a1} ] ; In D_tot ; Jacobian JVol ; }}}
   { Name B1 ; Value { Local { [ {Curl a1} ] ; In D_tot ; Jacobian JVol ; }}}
   { Name J_s ; Value { Local { [ J_s[$X,$Y,$Z] ] ; In Coil ; Jacobian JSur ; }}}
   { Name a2 ; Value { Local { [ {a2} ] ; In D_tot ; Jacobian JSur ; }}}
//   { Name B2 ; Value { Local { [ {Curl a2} ] ; In D_tot ; Jacobian JVol ; }}}
//   { Name B2 ; Value { Local { [ {B2} ] ; In D_tot ; Jacobian JVol ; }}}
//   { Name N ; Value { Local { [ Normal[] ] ; In Coil ; Jacobian JVol ; }}}
   { Name B2Z ; Value { Local { [ Vector[0,0,2*CompZ[{B2}]] ] ; In D_tot ; Jacobian JVol ; }}}

    }
  }
}

PostOperation {
  { Name post_operations ; NameOfPostProcessing post_processing;
    Operation {
//	Print[ a1, OnElementsOf D_tot, File "a1.pos" ] ;
	Print[ B1, OnElementsOf D_tot, File "B1.pos" ] ;
	Print[ J_s, OnElementsOf Coil, File "J_s.pos" ] ;
	Print[ a2, OnElementsOf D_tot, File "a2.pos" ] ;
//	Print[ N, OnElementsOf Coil, File "N.pos" ] ;
	Print[ B2Z, OnElementsOf D_tot, File "B2Z.pos" ] ;

    }
  }
}


