Include "torus.par" ;

// characteristic lengths :

lc0 = 0.15 ;	// coil section (half plane X>0, Z=0) 
lc1 = 0.6 ;	// near 0
lc2 = 0.6 ;	// R_int
lc3 = 0.9 ;	// R_ext
lc4 = 0.4 ;	// coil section (half plane X<0, Z=0) (useless if the coil is extruded)


Point(1) = {0,0,0, lc1} ;

Point(2) = {0,R_int,0, lc2} ;
Point(3) = {0,R_ext,0, lc3} ;

Point(4) = {R_int,0,0, lc2} ;
Point(5) = {R_ext,0,0, lc3} ;

Point(6) = {0,-R_int,0, lc2} ;
Point(7) = {0,-R_ext,0, lc3} ;

Line(1) = {1,2} ;
Line(3) = {1,6} ;

Line(4) = {2,3} ;
Line(5) = {4,5} ;
Line(6) = {6,7} ;

Circle(7) = {2,1,4} ;
Circle(8) = {3,1,5} ;
Circle(9) = {4,1,6} ;
Circle(10) = {5,1,7} ;

Point(51) = {1,  1, 0, lc0} ;
Point(52) = {2,  1, 0, lc0} ;
Point(53) = {2, -1, 0, lc0} ;
Point(54) = {1, -1, 0, lc0} ;

Line(51) = {51,52} ;
Line(52) = {52,53} ;
Line(53) = {53,54} ;
Line(54) = {54,51} ;

Line Loop(55) = {4,8,-5,-7};
Plane Surface(56) = {55};
Line Loop(57) = {9,6,-10,-5};
Plane Surface(58) = {57};
Line Loop(59) = {1,7,9,-3};
Line Loop(60) = {51,52,53,54};
Plane Surface(61) = {59,60};
Plane Surface(62) = {60};

Extrude { {0,1,0}, {0,0,0}, +Pi} {
	Line {54,51,52,53};	
/***
// For an extruded mesh, uncomment this :
	Layers{ 12, 1 } ;
	Recombine ;
**********************************/
}

Characteristic Length { 66,55,56,64 } = lc4 ;

Physical Line(63) = {54,51,52,53};
Physical Line(64) = {8,10};
Physical Line(65) = {1,3,4,6};

Physical Surface(66) = {62,61};
Physical Surface(67) = {56,58};

Physical Surface(79) = {70,74,78,66};

